StoryButtonFont = {
  standardFont,
  18,
  Color(131, 167, 184, 255), 
};


NextGraphics = {
	"Story/nextnormal",
	"Story/nextmousedown",
	"Story/nextmouseover"
};


NextStyle = {
	parent = DefaultStyle,
	font = StoryButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = NextGraphics,
};


PreviousGraphics = {
	"Story/previousnormal",
	"Story/previousmousedown",
	"Story/previousmouseover"
};


PreviousStyle = {
	parent = DefaultStyle,
	font = StoryButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = PreviousGraphics ,
};


SkipGraphics = {
	"Story/skipnormal",
	"Story/skipmousedown",
	"Story/skipmouseover"
};


SkipStyle = {
	parent = DefaultStyle,
	font = StoryButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = SkipGraphics,
};


MakeDialog
{
	-- Name the modal dialog
	name="ScreenWindow",		
			
	ScreenWindow
	{
		x=0,
		y=0,
		w=800,
		h=600,

		Bitmap
		{
			name="1buttonholder",
			image="Story/1buttonholder", 
			x = 590,
			y = 550,
		},
		Bitmap
		{
			name="2buttonholder",
			image="Story/2buttonholder", 
			x = 590,
			y = 550,
		},		
		
		Bitmap
		{
			name="3buttonholder",
			image="Story/3buttonholder", 
			x = 501,
			y = 550,
		},
			
		SetStyle(NextStyle);		
		Button
		{
			x=695,
			y=560,
			font = StoryButtonFont,
			graphics = SkipGraphics,
			name="next",
			label="next",
			type = kPush,
			command=
				function()
					SendGameMessage("next");
				end
		},
		
		SetStyle(PreviousStyle);
		Button
		{
			x=515,
			y=560,
			font = StoryButtonFont,
			graphics = PreviousGraphics,
			name="prev",
			label="prev",
			type = kPush,
			command=
				function()
					SendGameMessage("previous");
				end
		},
		SetStyle(SkipStyle);
		Button
		{
			x=606,
			y=560,
			font = StoryButtonFont,
			graphics = NextGraphics,
			name="lastprev",
			label="prev",
			type = kPush,
			command=
				function()
					EnableWindow("lastprev", false);
					EnableWindow("2buttonholder", false);
					SendGameMessage("previous");
				end
		},
		
		SetStyle(SkipStyle);
		Button
		{
			x=606,
			y=560,
			font = StoryButtonFont,
			graphics = NextGraphics,
			name="skip",
			label="skip",
			type = kPush,
			command=
				function()
					SendGameMessage("skip");
				end
		},	
	},		
}

EnableWindow("lastprev", false);
